
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MENUS.C - Labmon Menus
// 
//
//   DESCRIPTION
//
//   Functions to display the various menus used in Labmon.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MENUS.C_v  $
//   
//      Rev 1.25   07 Jan 2000 14:55:14   phungh
//   Labmon60 : Roll up version number to 6.0
//   
//      Rev 1.24   15 Dec 1999 14:27:46   phungh
//   roll up s/w ver to 5.9
//   
//      Rev 1.23   08 Dec 1999 16:19:30   phungh
//   Roll up the software version
//   
//      Rev 1.22   27 Apr 1999 14:59:12   phungh
//   labmon55 : Modification for AMD flash
//   download.  Rolled up s/w version to 5.5
//   
//      Rev 1.21   21 Apr 1999 11:41:38   phungh
//   Labmon54 : Roll up S/W version to 5.4
//   
//      Rev 1.20   15 Dec 1998 14:27:06   phungh
//   Labmon53 : Fix flash download in "slow
//   mode" ,and record "in/out of NAV"
//   occurance using "xtract COV"
//   
//      Rev 1.19   11 Nov 1998 11:52:12   phungh
//   lbmon522 : Add logging the EVPE to file
//   "cov.txt" when the EVPE value is crossing
//   the set value in either direction.  Changes 
//   made to labmon.c and msg1000.c

//      Rev 1.18   11 Nov 1998 10:56:44   phungh
//   lbmon521: Log the EHPE to file "cov.txt"
//   when the EHPE value passing the set
//   value in either direction.  Change made to
//   labmon.c and msg1000.c
//   
//      Rev 1.17   10 Nov 1998 18:09:52   phungh
//   labmon52: Fix extract data bug.  svout()
//   did not get called at " case 16 : " which is
//   quitting program.
//   
//      Rev 1.16   10 Nov 1998 13:57:36   phungh
//   Lbmon511: Add cF7 key combination to
//   the menu to allow choosing antenna type
//   ( passive / active ).  Msg1218 module was
//   added.
//
//      Rev 1.15   09 Nov 1998 10:26:52   phungh
//   labmon51: Fix file logging and missing 
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of
//   time spent too long in the interrupt handler
//   
//      Rev 1.12   Jul 06 1998 09:08:18   BANHND
//   added more DR features
//   
//      Rev 1.9   Jul 10 1997 09:06:24   COLEJ
//   rolled ver number to 4.80
//   
//      Rev 1.8   Jul 09 1997 09:47:40   COLEJ
//   Multiple Changes...
//   
//      Rev 1.7   Feb 25 1997 14:33:14   COLEJ
//   Power management added to menu for 
//   zodiac binary
//   
//      Rev 1.6   Feb 12 1997 16:05:10   COLEJ
//    
//   
//      Rev 1.5   Nov 14 1996 11:25:18   COLEJ
//    
//   
//      Rev 1.4   Oct 31 1996 11:28:32   COLEJ
//    
//   
//      Rev 1.3   Aug 26 1996 18:42:46   COLEJ
//    
//   
//      Rev 1.2   Aug 14 1996 08:37:48   COLEJ
//    
//
//      Rev 1.0   13 May 1996 14:52:38   GPSADMIN
//   Initial release to version control.
//
//      Rev 1.1   Aug 14 1996 08:28:30   COLEJ
//   Changed version number to 4.7B
//
//
////////////////////////////////////////////////////////////////////////////////

#include <graph.h> 
#include <string.h> 

#include "LABMON.H"
#include "DISPLAY.H"
#include "MENUS.H"
#include "ZCONS.H"


// Version number displayed at startup.
//
#define LABMON_VERSION  "V 6.0"


extern tDATATYPE DataType;

extern short playback;
extern short MainTextColor;   
extern short MainDataColor;   
extern short MainBackColor; 
extern short MenuKeysColor;   
extern short MenuDescColor;   
extern short MenuBackColor;      
extern char  *Clear;


// display_menus 

void display_menus(short *current_menu)
{      
   // do not display normal menus in replay mode
   if(!playback){ 
      
      menu_on = 1;    
           
      switch (*current_menu){  
           case 1:   
            display_menu_1(); 
              break;   
           case 2:   
            display_menu_2(); 
              break;   
           case 3:   
            display_menu_3(); 
              break;   
           case 4:   
            display_menu_4(); 
              break;   
           default:    
            display_menu_1(); 
            *current_menu = 1;  
      }
   }   
}

// display_menu_1()                             

void display_menu_1(void)
{                           
   short row = 0;

   _setbkcolor(MenuBackColor);
   _settextcolor(MenuKeysColor);  
   _settextposition(row++,CNTC); _outtext(Clear);
   _settextposition(row++,CNTC); _outtext(" GPS INPUT OPTIONS ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F1  ");
   _settextcolor(MenuDescColor); _outtext("TIME INIT     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F2  ");
   _settextcolor(MenuDescColor); _outtext("POS & VEL INIT");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F3  ");
   _settextcolor(MenuDescColor); _outtext("ALTITUDE INPUT");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F4  ");
   _settextcolor(MenuDescColor); _outtext("DATUM DEFINE  ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F5  ");
   _settextcolor(MenuDescColor); _outtext("TIMEMARK INIT ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F6  ");
   _settextcolor(MenuDescColor); _outtext("Factory Test  ");
 

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F7  ");
   _settextcolor(MenuDescColor); _outtext("DR INIT       ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F8  ");
   _settextcolor(MenuDescColor); _outtext("BUILT-IN-TEST ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F9  ");
   _settextcolor(MenuDescColor); _outtext("GyroFactryTest");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F10 ");
   _settextcolor(MenuDescColor); _outtext("Send Char 2 Rx");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F11 ");
   _settextcolor(MenuDescColor); _outtext("RESET RECEIVER");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" F12 ");  
   _settextcolor(MenuDescColor); _outtext("RESET COUNTERS");
                                                      
   _settextposition(row++,CNTC); _outtext(Clear);

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" M ");
   _settextcolor(MenuDescColor); _outtext("MENU   ");
   _settextcolor(MenuKeysColor); _outtext("N ");
   _settextcolor(MenuDescColor); _outtext("NOMENU ");
 
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" R ");
   _settextcolor(MenuDescColor); _outtext("REPLAY ");
   _settextcolor(MenuKeysColor); _outtext("P ");
   _settextcolor(MenuDescColor); _outtext("PAUSE  ");
   
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" F ");
   _settextcolor(MenuDescColor); _outtext("FILTER ");
   _settextcolor(MenuKeysColor); _outtext("D ");
   _settextcolor(MenuDescColor); _outtext("DELTA  ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" Q ");
   _settextcolor(MenuDescColor); _outtext("QUIT   "); 
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR  ");

 
   while(row <= 18){
      _settextposition(row++,CNTC);
      _outtext(Clear);
   }

   _setbkcolor(MainBackColor) ; 
   _settextcolor(MainDataColor); 
}

// display_menu_2()                             

void display_menu_2(void)
{ 
   short row = 0;
 
   _setbkcolor(MenuBackColor);
   _settextcolor(MenuKeysColor);
   _settextposition(row++,CNTC); _outtext(Clear);
   _settextposition(row++,CNTC); _outtext(" GPS I/O OPTIONS   ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF1  ");
   _settextcolor(MenuDescColor); _outtext("GPS I/O PORTS");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF2  ");
   _settextcolor(MenuDescColor); _outtext("GPS MSG TYPE ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF3  ");
   _settextcolor(MenuDescColor); _outtext("MSG LOG CTRL ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF4  ");
   _settextcolor(MenuDescColor); _outtext("MSG QUERY    ");    

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF5  ");
   _settextcolor(MenuDescColor); _outtext("NMEA GEN MSG ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF6  ");
   _settextcolor(MenuDescColor); _outtext("NMEA TYP MSGS");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF7  ");
   _settextcolor(MenuDescColor); _outtext("RESERVED     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF8  ");
   _settextcolor(MenuDescColor); 
   if((DataType == NC_BINARY)||(DataType == Z_BINARY))     _outtext("STORE ALM/UTC");
   else                                                    _outtext("RESERVED     ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF9  ");
   _settextcolor(MenuDescColor); 
   if(DataType == NC_BINARY)     _outtext("REQ PRANGES  ");
   else                          _outtext("RESERVED     ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF10 ");
   _settextcolor(MenuDescColor); 
   if(DataType == Z_BINARY)     _outtext("STORE EPHEMER");
   else                          _outtext("RESERVED     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF11 ");
   _settextcolor(MenuDescColor); 
   if(DataType == Z_BINARY)     _outtext("LOAD EPHEMERI");
   else                          _outtext("RESERVED     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" sF12 ");
   _settextcolor(MenuDescColor); 
   if((DataType == NC_BINARY)||(DataType == Z_BINARY))     _outtext("LOAD ALM/UTC "); 
   else                                                    _outtext("RESERVED     ");

                                                      
   _settextposition(row++,CNTC); _outtext(Clear);
   
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" M ");
   _settextcolor(MenuDescColor); _outtext("MENU   ");
   _settextcolor(MenuKeysColor); _outtext("N ");
   _settextcolor(MenuDescColor); _outtext("NOMENU ");
 
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" R ");
   _settextcolor(MenuDescColor); _outtext("REPLAY ");
   _settextcolor(MenuKeysColor); _outtext("P ");
   _settextcolor(MenuDescColor); _outtext("PAUSE  ");
   
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" F ");
   _settextcolor(MenuDescColor); _outtext("FILTER ");
   _settextcolor(MenuKeysColor); _outtext("D ");
   _settextcolor(MenuDescColor); _outtext("DELTA  ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" Q ");
   _settextcolor(MenuDescColor); _outtext("QUIT   "); 
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR  ");

   while(row <= 18){
      _settextposition(row++,CNTC);
      _outtext(Clear);
   }  
                   
   _setbkcolor(MainBackColor) ;     
   _settextcolor(MainDataColor);
}

// display_menu_3()           

void display_menu_3(void)
{  
   short row = 0;
 
   _setbkcolor(MenuBackColor);
   _settextcolor(MenuKeysColor);
   _settextposition(row++,CNTC); _outtext(Clear);
    _settextposition(row++,CNTC); _outtext(" SOLUTION CONTROL  ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF1  ");
   _settextcolor(MenuDescColor); _outtext("NAV VALIDITY ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF2  ");
   _settextcolor(MenuDescColor); _outtext("PLATFORM TYPE");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF3  ");
   _settextcolor(MenuDescColor); _outtext("NAV CONFIG   ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF4  ");
   _settextcolor(MenuDescColor); _outtext("RESERVED     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF5  ");
   _settextcolor(MenuDescColor); _outtext("COLD START   ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF6  ");
   _settextcolor(MenuDescColor); _outtext("DATUM SELECT ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF7  ");
   _settextcolor(MenuDescColor); _outtext("ANTENNA TYPE ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF8  ");
   _settextcolor(MenuDescColor); _outtext("ANT ELEV MASK");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF9  ");
   _settextcolor(MenuDescColor); _outtext("SV SELECTION ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF10 ");
   _settextcolor(MenuDescColor); _outtext("DGPS CONTROL ");
   
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" cF11 "); 
   _settextcolor(MenuDescColor);
   if((DataType == NC_BINARY) || (DataType == Z_BINARY))     _outtext("POWER MGMNT  ");
   else                                                      _outtext("RESERVED     ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext("      ");
   _settextcolor(MenuDescColor); _outtext("             ");
                                                     
   _settextposition(row++,CNTC); _outtext(Clear);

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" M ");
   _settextcolor(MenuDescColor); _outtext("MENU   ");
   _settextcolor(MenuKeysColor); _outtext("N ");
   _settextcolor(MenuDescColor); _outtext("NOMENU ");
 
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" R ");
   _settextcolor(MenuDescColor); _outtext("REPLAY ");
   _settextcolor(MenuKeysColor); _outtext("P ");
   _settextcolor(MenuDescColor); _outtext("PAUSE  ");
   
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" F ");
   _settextcolor(MenuDescColor); _outtext("FILTER ");
   _settextcolor(MenuKeysColor); _outtext("D ");
   _settextcolor(MenuDescColor); _outtext("DELTA  ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" Q ");
   _settextcolor(MenuDescColor); _outtext("QUIT   "); 
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR  ");
  
   while(row <= 18){
      _settextposition(row++,CNTC);
      _outtext(Clear);
   }    
 
   _setbkcolor(MainBackColor) ;
   _settextcolor(MainDataColor);   
} 

// display_menu_4()                             

void display_menu_4(void)
{  
   short row = 0;
 
   _setbkcolor(MenuBackColor); 
   _settextcolor(MenuKeysColor);

   _settextposition(row++,CNTC); _outtext(Clear);
   _settextposition(row++,CNTC); _outtext(" LABMON CFG OPTIONS");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF1  ");
   _settextcolor(MenuDescColor); _outtext("LAB I/O PORTS");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF2  ");
   _settextcolor(MenuDescColor); _outtext("LAB MSG TYPE "); 
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF3  "); 
   _settextcolor(MenuDescColor); _outtext("REFERENCE POS");  
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF4  "); 
   _settextcolor(MenuDescColor); _outtext("MAIN BACK CLR");
  
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF5  ");
   _settextcolor(MenuDescColor); _outtext("MAIN TEXT CLR");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF6  ");
   _settextcolor(MenuDescColor); _outtext("MAIN DATA CLR");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF7  ");
   _settextcolor(MenuDescColor); _outtext("MENU BACK CLR");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF8  ");
   _settextcolor(MenuDescColor); _outtext("MENU KEY  CLR");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" aF9  ");
   _settextcolor(MenuDescColor); _outtext("MENU DESC CLR");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext("      ");
   _settextcolor(MenuDescColor); _outtext("             ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext("      ");
   _settextcolor(MenuDescColor); _outtext("             ");
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" M ");
   _settextcolor(MenuDescColor); _outtext("MENU   ");
   _settextcolor(MenuKeysColor); _outtext("N ");
   _settextcolor(MenuDescColor); _outtext("NOMENU ");
 
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" R ");
   _settextcolor(MenuDescColor); _outtext("REPLAY ");
   _settextcolor(MenuKeysColor); _outtext("P ");
   _settextcolor(MenuDescColor); _outtext("PAUSE  ");
   
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" F ");
   _settextcolor(MenuDescColor); _outtext("FILTER ");
   _settextcolor(MenuKeysColor); _outtext("D ");
   _settextcolor(MenuDescColor); _outtext("DELTA  ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" Q ");
   _settextcolor(MenuDescColor); _outtext("QUIT   "); 
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR  ");
 
   while(row <= 18){
      _settextposition(row++,CNTC);
      _outtext(Clear);
   }  
 
   _setbkcolor(MainBackColor) ;
   _settextcolor(MainDataColor);  
}
   
// display_menu_5()                            

void display_menu_5(void)
{ 
   short row = 0;
 
   _setbkcolor(MenuBackColor);
   _settextcolor(MenuKeysColor);
   _settextposition(row++,CNTC); _outtext(Clear);
   _settextposition(row++,CNTC); _outtext("     MODE MENU   ");
 
   _settextcolor(MenuKeysColor); _outtext(" INS ");
   _settextcolor(MenuDescColor); _outtext("Record Data   ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" DEL ");
   _settextcolor(MenuDescColor); _outtext("Playback Data "); 
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" PUP ");
   _settextcolor(MenuDescColor); _outtext("Extract Data  ");  
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" PDN ");
   _settextcolor(MenuDescColor); _outtext("Monitor Data  ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" TAB ");
   _settextcolor(MenuDescColor); _outtext("Record On/Off ");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" SPC ");
   _settextcolor(MenuDescColor); _outtext("Play/Pause    ");

   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
   _settextposition(row++,CNTC); _outtext(Clear); 
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" M ");
   _settextcolor(MenuDescColor); _outtext("MENU    ");
   _settextcolor(MenuKeysColor); _outtext("N ");
   _settextcolor(MenuDescColor); _outtext("NOMENU");
 
   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" S ");
   _settextcolor(MenuDescColor); _outtext("SCREEN  ");
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR ");
 
   _settextposition(row++,CNTC);      
   _settextcolor(MenuKeysColor); _outtext(" R ");
   _settextcolor(MenuDescColor); _outtext("RUN     ");
   _settextcolor(MenuKeysColor); _outtext("Q ");   
   _settextcolor(MenuDescColor); _outtext("QUIT  ");
}

// display replay menu
void display_replay_menu(void)
{
   short row = 0; 
   
   row = REPR-2;
 
   _setbkcolor(MenuBackColor); 
   _settextcolor(MenuKeysColor);
 
   _settextposition(row++,REPC);
   _settextcolor(MenuKeysColor); _outtext(" +-");
   _settextcolor(MenuDescColor); _outtext("SPEED  ");
   _settextcolor(MenuKeysColor); _outtext("<>");
   _settextcolor(MenuDescColor); _outtext("STEP   ");
 
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" X ");
   _settextcolor(MenuDescColor); _outtext("XTRACT ");
   _settextcolor(MenuKeysColor); _outtext("F ");
   _settextcolor(MenuDescColor); _outtext("FILTER ");   
   
   _settextposition(row++,CNTC);  
   _settextcolor(MenuKeysColor); _outtext(" D ");
   _settextcolor(MenuDescColor); _outtext("DELTA  ");
   _settextcolor(MenuKeysColor); _outtext("P ");
   _settextcolor(MenuDescColor); _outtext("PAUSE  ");

   _settextposition(row++,CNTC);
   _settextcolor(MenuKeysColor); _outtext(" Q ");
   _settextcolor(MenuDescColor); _outtext("QUIT   "); 
   _settextcolor(MenuKeysColor); _outtext("C ");
   _settextcolor(MenuDescColor); _outtext("CLEAR  ");
 
   while(row <= 18){
      _settextposition(row++,CNTC);
      _outtext(Clear);
   }  
 
   _setbkcolor(MainBackColor) ;
   _settextcolor(MainDataColor);  
}

// display title

void display_title(void)
{
   _settextposition(MSGR, MSGC);
   _outtext(LABMON_VERSION);
}                    
